(function() {
  //farmerswife 04/02/2014 Rafa Dorado
  define(['jquery', 'underscore', 'Handlebars', 'Backbone', 'moment', "views/menu/MenuView", 'models/contact/ContactModel', "views/cfield/CustomFieldView", 'PrecompiledTemplates'], function($, _, Handlebars, Backbone, Moment, MenuView, ContactModel, CustomFieldView) {
    var FormContactView;
    return FormContactView = class FormContactView extends Backbone.View {
      initialize(usr, contactsCol, contact1) {
        this.usr = usr;
        this.contactsCol = contactsCol;
        this.contact = contact1;
        return this.listenTo(this.contactsCol, 'companies_filled', this.__fill_selects_page);
      }

      events() {
        return {
          'tap #id-btn-back': 'btnBackClicked',
          'tap .btn-submenu-addcontact': 'subMenuAddContactClicked',
          'tap #id-btn-save-contact': 'btnSaveClicked',
          'tap #id-btn-delete-contact': 'btnDeleteClicked',
          'change #id-select-company-categories': 'selCategoryChanged',
          'change #id-select-contact-titles': 'selTitleChanged',
          'change #id-select-contact-companies': 'selCompanyChanged'
        };
      }

      //'pageshow' : 'pageShown'
      render() {
        var hideUserNumber, ref, template;
        template = Handlebars.templates['FormContactView'];
        this.$el.html(template({
          contact: (ref = this.contact) != null ? ref.get('Contact') : void 0
        }));
        this.addSidePanel();
        this.$el.attr('id', 'id-AddContactView');
        hideUserNumber = this.usr.get('hideUserNumber');
        if (hideUserNumber) {
          return $('#form-id-div-other-info').hide();
        }
      }

      //pageShown:() ->
      //if @contact?.get('Contact') then @contactsCol.trigger('companies_filled')
      addSidePanel() {
        if (window.media_query_min_width(768)) {
          if (!MenuView) {
            MenuView = require("views/menu/MenuView");
          }
          this.panel = new MenuView(this.usr, this.obj);
          this.panel.render();
          return this.$el.append(this.panel.el);
        }
      }

      subMenuAddContactClicked(event) {
        var btn, id;
        event.preventDefault();
        event.stopPropagation();
        btn = $(event.currentTarget);
        if (!btn.hasClass('ui-disabled')) {
          id = btn.attr('data-target');
          $('.subAddcontactView').hide();
          return $(id).show();
        }
      }

      selCategoryChanged(event) {
        var category;
        category = $(event.currentTarget).val();
        if (category === 'new') {
          this.$el.find('#id-input-category').val('');
          this.$el.find('#div-company-category').show();
          return;
        }
        this.$el.find('#div-company-category').hide();
        return this.$el.find('#id-input-category').val(category);
      }

      selTitleChanged(event) {
        var title;
        title = $(event.currentTarget).val();
        if (title === 'new') {
          this.$el.find('#id-input-title').val('');
          this.$el.find('#div-contact-title').show();
          return;
        }
        this.$el.find('#div-contact-title').hide();
        return this.$el.find('#id-input-title').val(title);
      }

      selCompanyChanged(event) {
        var companyID;
        event.preventDefault();
        event.stopPropagation();
        companyID = $(event.currentTarget).val();
        if (companyID === 'new') {
          this.$el.find('#id-input-company').val('');
          this.$el.find('#div-contact-company').show();
          return;
        }
        $.mobile.loading('show');
        this.company = new ContactModel().get_details_company(this.usr.get('sessionID'), companyID, false);
        return this.company.on('companyFilled', this.__company_filled, this);
      }

      __company_filled() {
        var cFields, ref, ref1, ref2, ref3, stFields;
        $.mobile.loading('hide');
        // CLEAN ALL COMPANY RELEATED INPUTS
        this.$el.find('#id-input-www').val("");
        this.$el.find('#id-input-other').val("");
        this.$el.find('#id-input-phoneWork').val("");
        this.$el.find('#id-input-fax').val("");
        this.$el.find('#id-input-note').val("");
        this.$el.find('#id-textarea-address').val("");
        // CLEAN ALL COMPANY CFIELDS

        //company = _.findWhere(companies,{companyID:companyID})
        this.$el.find('#div-contact-company').hide();
        this.$el.find('#id-input-company').val((ref = this.company) != null ? (ref1 = ref.get('Company')) != null ? ref1.name : void 0 : void 0);
        // STANDARD FIELDS POPULATE WITH COMPANY VALUES
        stFields = (ref2 = this.company) != null ? ref2.get('Company').StandardField : void 0;
        if (!_.isArray(stFields)) {
          stFields = [stFields];
        }
        _.each(stFields, (cf) => {
          var found, input, lbl, options;
          lbl = cf.fieldName;
          input = $('#id-input-' + lbl);
          if (lbl === 'address') {
            input = $('#id-textarea-' + lbl);
          }
          if (lbl === 'category') {
            options = $('#id-select-company-categories option');
            found = false;
            options.each(function() {
              if ($(this).val() === cf.fieldValue) {
                $(this).attr('selected', 'selected');
                return found = true;
              }
            });
            this.$el.find('#id-input-category').val(cf.fieldValue);
            if (!found) {
              this.$el.find('#div-company-category').show();
              this.$el.find('#id-select-company-categories option[value="new"]').attr('selected', 'selected');
            } else {
              this.$el.find('#div-company-category').hide();
            }
            return this.$el.find('#id-select-company-categories').selectmenu('refresh');
          } else {
            return input.val(cf.fieldValue);
          }
        });
        // CUSTOM FIELDS POPULATE WITH COMPANY VALUES
        cFields = (ref3 = this.company) != null ? ref3.get('Company').CustomField : void 0;
        if (!_.isArray(cFields)) {
          cFields = [cFields];
        }
        _.each(cFields, (cf) => {
          var fieldset, input_text, radios, str_value;
          // WE NEED AN ELSE IN CASE VALUE IS 0 FOR CHECKBOX
          if ("value" in cf) {
            fieldset = this.__get_cf_input(cf.label, cf.type);
            switch (cf.type) {
              case 'selector':
                input_text = fieldset.find('input[type=text]');
                radios = fieldset.find('input[type=radio]');
                _.each(radios, function(rd) {
                  rd = $(rd);
                  if (rd.val() === cf.value) {
                    return rd.attr('checked', true);
                  }
                });
                return input_text.val(cf.value);
              case 'date':
                fieldset.val(cf.value);
                fieldset.siblings('.btn-date-cfield').text(Moment(cf.value, 'YYYY-MM-DD').calendar());
                return console.log("DATE:" + cf.value);
              case 'entry':
                if ('canLinkToContact' in cf) {
                  return fieldset.find('.ui-btn-text').text(cf.value);
                } else {
                  return fieldset.val(cf.value);
                }
                break;
              case 'text':
                return fieldset.val(cf.value);
              case 'checkbox':
                str_value = "Yes";
                if (!cf.value) {
                  str_value = "No";
                }
                fieldset.siblings().find('span.selector-checkbox-cfield').text(str_value);
                return fieldset.val(cf.value);
            }
          }
        });
        return this.$el.find('#id-ul-addcontact-cfields').trigger('create');
      }

      __get_cf_input(lbl, type) {
        var input, lis;
        //li cfs
        lis = this.$el.find('#id-ul-addcontact-cfields li');
        input = null;
        _.each(lis, (li) => {
          var cls;
          if ($(li).find("span.label").text() === lbl) {
            switch (type) {
              case 'date':
                cls = '.input-date-cfield';
                break;
              case 'checkbox':
                cls = 'select.selector-checkbox-cfield';
                break;
              case 'entry':
                cls = '.' + type + '-cfield';
                if ($(li).find('.btn-contact-cfield').length > 0) {
                  cls = '.btn-contact-cfield';
                }
                break;
              default:
                cls = '.' + type + '-cfield';
            }
            input = $(li).find(cls);
          }
        });
        return input;
      }

      btnSaveClicked(event) {
        var companyID, contact, contactObject, ref;
        event.preventDefault();
        event.stopPropagation();
        contactObject = {};
        if (!((ref = this.contact) != null ? ref.get('Contact') : void 0)) {
          contactObject.contactID = 'new';
        } else {
          contactObject.contactID = this.contact.get('Contact').contactID;
        }
        contactObject.firstName = this.$el.find('#id-input-firstName').val();
        contactObject.lastName = this.$el.find('#id-input-lastName').val();
        contactObject.address = this.$el.find('#id-textarea-address').val();
        contactObject.other = this.$el.find('#id-input-other').val();
        contactObject.note = this.$el.find('#id-addcontact-note').val();
        contactObject.phoneWork = this.$el.find('#id-input-phoneWork').val();
        contactObject.phoneDirect = this.$el.find('#id-input-phoneDirect').val();
        contactObject.phoneMobile = this.$el.find('#id-input-phoneMobile').val();
        contactObject.phoneHome = this.$el.find('#id-input-phoneHome').val();
        contactObject.fax = this.$el.find('#id-input-fax').val();
        contactObject.email = this.$el.find('#id-input-email').val();
        contactObject.www = this.$el.find('#id-input-www').val();
        //SELECTS
        contactObject.type = this.$el.find('#id-select-contact-type').val();
        contactObject.title = this.$el.find('#id-input-title').val();
        contactObject.category = this.$el.find('#id-input-category').val();
        contactObject.companyName = this.$el.find('#id-input-company').val();
        companyID = this.$el.find('#id-select-contact-companies').val();
        contactObject.companyID = companyID;
        contactObject.CustomField = new Array();
        _.each($('#id-ul-addcontact-cfields > li'), function(cf) {
          var cfObj, input, ref1, ref2, type, value;
          type = $(cf).attr('data-type');
          switch (type) {
            case 'checkbox':
              value = $(cf).find('select.selector-checkbox-cfield').val();
              break;
            case 'entry':
              if (((ref1 = $(cf).find('.selector-company-cfield')) != null ? ref1.length : void 0) > 0) {
                value = $(cf).find('span.selector-company-cfield').text();
              } else if (((ref2 = $(cf).find('.btn-contact-cfield')) != null ? ref2.length : void 0) > 0) {
                value = $(cf).find('.btn-contact-cfield').text();
              } else {
                value = $(cf).find('.entry-cfield').val();
              }
              break;
            case 'text':
              value = $(cf).find('.text-cfield').val();
              break;
            case 'selector':
              input = $(cf).find('.input-selector-cfield').val();
              if (input) {
                value = input;
              } else {
                value = $(cf).find('.radio-selector-cfield').val();
              }
              break;
            case 'date':
              value = $(cf).find('.input-date-cfield').val();
          }
          if (!value) {
            value = "";
          }
          cfObj = {
            label: window.html_entities($(cf).attr('data-label')),
            value: window.html_entities(value),
            type: type
          };
          return contactObject.CustomField.push(cfObj);
        });
        contact = new ContactModel();
        contact.on('change', this.__refresh_and_go_to_contact, this);
        return contact.save_contact(this.usr.get('sessionID'), contactObject);
      }

      btnDeleteClicked(event) {
        event.preventDefault();
        event.stopPropagation();
        this.contactsCol.on('contact_deleted', this.__refresh_and_go_to_contactList, this);
        return this.contactsCol.delete_contact(this.usr, this.contact.get('Contact').contactID);
      }

      __refresh_and_go_to_contactList() {
        this.contactsCol.get_contacts(this.usr);
        return $.mobile.jqmNavigator.popToFirst({
          transition: 'none'
        });
      }

      __refresh_and_go_to_contact() {
        if (this.contact) {
          this.contact.get_details_contact(this.usr.get('sessionID'), this.contact.get('Contact').contactID);
        }
        this.contactsCol.get_contacts(this.usr);
        return $.mobile.jqmNavigator.popView({
          transition: 'none'
        });
      }

      __update_cfields_tap(cfields) {
        var ul;
        if (cfields === 'company') {
          cfields = this.company.get('Company').CustomField;
        } else {
          if (this.contact) {
            cfields = this.contact.get('Contact').CustomField;
          } else {
            cfields = JSON.parse('[' + window.localStorage.getItem('ContactCFields') + ']');
          }
        }
        if (!_.isArray(cfields)) {
          cfields = [cfields];
        }
        //# CHECK IF EMPTY
        if (!cfields[0]) {
          return;
        }
        if (!CustomFieldView) {
          CustomFieldView = require("views/cfield/CustomFieldView");
        }
        if (cfields) {
          ul = $('#id-ul-addcontact-cfields');
          ul.empty();
          _.each(cfields, (cf) => {
            var cfLi;
            cfLi = new CustomFieldView(this.usr, cf, 'form', 'FormContactView').render().el;
            return ul.append(cfLi);
          });
          /* UPDATING DOM STYLE */
          $('#id-divAddcontactCFields').trigger('create');
          return $('#id-ul-addcontact-cfields').listview();
        }
      }

      //$('#id-ul-addcontact-cfields').listview('refresh')
      __fill_selects_page() {
        var catFound, categories, companies, contact, ref, ref1, ref2, ref3, sel, titleFound, titles, types;
        //GET CONTACT IN CASE OF EDITING
        contact = (ref = (ref1 = this.contact) != null ? ref1.get('Contact') : void 0) != null ? ref : null;
        //PRINT CUSTOM FIELD TAP
        this.__update_cfields_tap();
        //CONTACT TITLES
        titles = (ref2 = window.localStorage.getItem('ContactTitles')) != null ? ref2.split(',') : void 0;
        sel = $('#id-select-contact-titles');
        sel.empty();
        sel.append("<option value=\"\">Select a Title</option>");
        titleFound = false;
        _.each(titles, function(tit) {
          var opt, selected;
          selected = '';
          if ((contact != null ? contact.title : void 0) === tit) {
            selected = 'selected=selected';
            titleFound = true;
          }
          opt = `<option value=\"${tit}\" ${selected}>${tit}</option>`;
          return sel.append(opt);
        });
        if (!titleFound && contact) {
          $('id-input-title').val(contact != null ? contact.title : void 0);
          $('#div-contact-title').show();
        }
        sel.append("<option value=\"new\">Add Custom Title</option>");
        sel.selectmenu('refresh');
        //CONTACT TYPES
        types = {};
        types['Global'] = 'global';
        if (!this.usr.__can_not_edit_contact_if_resource()) {
          types['Resource'] = 'resource';
        }
        if (!this.usr.__can_not_edit_contact_if_client()) {
          types['Client'] = 'client';
        }
        types['Private'] = 'private';
        sel = $('#id-select-contact-type');
        sel.empty();
        sel.append("<option value=\"\">Select a Type</option>");
        _.each(_.keys(types), function(k) {
          var opt, selected;
          selected = (contact != null ? contact.type : void 0) === types[k] ? 'selected=selected' : '';
          opt = `<option value=\"${types[k]}\" ${selected}>${k}</option>`;
          return sel.append(opt);
        });
        sel.selectmenu('refresh');
        //COMPANY CATEGORIES
        categories = (ref3 = window.localStorage.getItem('CompanyCategories')) != null ? ref3.split(',') : void 0;
        sel = $('#id-select-company-categories');
        sel.empty();
        sel.append("<option value=\"\">Select a Category</option>");
        catFound = false;
        _.each(categories, function(cat) {
          var opt, selected;
          selected = '';
          if ((contact != null ? contact.category : void 0) === cat) {
            selected = 'selected=selected';
            catFound = true;
          }
          opt = `<option value=\"${cat}\" ${selected}>${cat}</option>`;
          return sel.append(opt);
        });
        if (!catFound && contact) {
          $('id-input-category').val(contact != null ? contact.category : void 0);
          $('#div-company-category').show();
        }
        sel.append("<option value=\"new\">Add Custom Category</option>");
        sel.selectmenu('refresh');
        //COMPANY LIST
        companies = JSON.parse('[' + window.localStorage.getItem('CompanyList') + ']');
        sel = $('#id-select-contact-companies');
        sel.empty();
        sel.append("<option value=\"\">Select a Company</option>");
        _.each(companies, (comp) => {
          var opt, selected;
          selected = (contact != null ? contact.companyID : void 0) === (comp != null ? comp.companyID : void 0) ? 'selected=selected' : '';
          opt = `<option value=\"${comp != null ? comp.companyID : void 0}\" ${selected}>${comp != null ? comp.name : void 0}</option>`;
          return sel.append(opt);
        });
        sel.append("<option value=\"new\">Add Custom Company</option>");
        return sel.selectmenu('refresh');
      }

      addContactCfieldContact(view, previousView, contact) {
        var btn, obj;
        //liCfield = view.$el.find('.btn-contact-cfield[data-selected="true"]').closest('li').index()
        console.log(contact);
        console.log(previousView);
        $.mobile.jqmNavigator.popView({
          transition: 'none'
        });
        btn = view.$el.find('.btn-contact-cfield[data-selected="true"]');
        if (btn.length === 0) {
          btn = view.$el.find('.btn-contact-cfield');
        }
        obj = contact.get('Contact');
        //SINCE PAGE SHOWN EVENT, LIST WAS REPRINTED
        //btn = view.$el.find('#id-ul-formproject-cfields li').eq(liCfield).find('.btn-contact-cfield')
        btn.find('.ui-btn-text').text(obj.firstName + ' ' + obj.lastName);
        btn.attr('data-contactID', obj.contactID);
        btn.attr('data-selected', false);
        return btn.button();
      }

      //BACk BUTTON
      btnBackClicked() {
        event.stopPropagation();
        event.preventDefault();
        this.stopListening();
        return $.mobile.jqmNavigator.popView({
          transition: 'none'
        });
      }

    };
  });

}).call(this);
